module ThreeScale
  class ConfigurationError < StandardError; end

  ACCEPTED_TENANT_MODES = [nil, false, ''.freeze, 'developer'.freeze, 'provider'.freeze, 'multitenant'.freeze].freeze

  extend ActiveSupport::Autoload
  extend self

  eager_autoload do
    autoload :Analytics
    autoload :PrivateModule
  end

  def config
    System::Application.config.three_scale
  end

  def likely_multitenant?
    !tenant_mode.present? || tenant_mode.multitenant?
  end

  def tenant_mode
    config.tenant_mode.to_s.inquiry
  end

  def validate_settings!
    raise ConfigurationError unless validate_settings
  end

  def validate_settings
    ACCEPTED_TENANT_MODES.include?(tenant_mode)
  end

  extend PrivateModule
end
