module ApiAuthentication
  module ByProviderKey
    extend ActiveSupport::Concern
    included do
      include ApiAuthentication::HttpAuthentication
    end

    private

    def current_account
      @current_account ||= if current_user
        current_user.account
                           elsif provider_key
        Account
          .providers_with_master
          .by_self_domain(request.host)
          .find_by_provider_key(provider_key)
      end
    end

    def logged_in?
      !current_account.nil?
    end

    def provider_key
      return @_provider_key if instance_variable_defined?(:@_provider_key)

      @_provider_key = params.fetch(:provider_key, &method(:http_authentication))
    end
  end
end
