@stats
Feature: All kind of contracts are billed
  In order to have flexibility in billing operations
  As a provider
  I want to be bill account, service and application contracts separately

Background:
  Given a provider "xyz.example.com" with billing enabled
      And provider "xyz.example.com" has "finance" switch visible
    And a default service of provider "xyz.example.com" has name "api"
    And a metric "transfer" of provider "xyz.example.com"

 Scenario: Monthly fee on all levels (account, service and application plan)
      Given the date is 1st January 2009
        And an account plan "Tier-1" of provider "xyz.example.com" for 100 monthly
        And a service plan "Gold" of service "api" for 10 monthly
        And an application plan "iPhone" of service "api" for 1 monthly

        And a buyer "not_very_rich" of provider "xyz.example.com"
        And buyer "not_very_rich" signed up for plans "Tier-1", "Gold", "iPhone"

      When buyer "not_very_rich" makes 3 service transactions with:
        | Metric   | Value |
        | hits     |     1 |
        | transfer |   500 |

      When time flies to 3rd March 2009
       And I log in as "not_very_rich" on xyz.example.com
       And I navigate to invoices issued for me
       And I should see 2 invoices

      When I navigate to invoice issued for me in "February, 2009"
      Then I should see line items
        | name                 | quantity |   cost |
        | Fixed fee ('Tier-1') |          | 100.00 |
        | Fixed fee ('Gold')   |          | 10.00  |
        | Fixed fee ('iPhone') |          | 1.00   |
        | Total cost           |          | 111.00 |
