module Api::IntegrationsHelper

  def api_test_curl(proxy, production=false)
    credentials = proxy.authentication_params_for_proxy
    credentials_3scale = proxy.authentication_params_for_proxy(original_names: true)
    extheaders = ''
    query = ''

    if proxy.credentials_location == 'headers'
      credentials.each { |k, v| extheaders += " -H'#{k}: #{v}'" }
    elsif test_path = proxy.api_test_path
      query = "#{(test_path.index('?') ? '&' : '?')}#{credentials.to_query}"
    else
      query = "?#{credentials.to_query}"
    end

    content_tag :code,
                id: (production ? 'api-production-curl' : 'api-test-curl'),
                'data-credentials' => credentials_3scale.to_json do
      %{curl "#{production ? proxy.hosted_proxy_endpoint : proxy.sandbox_endpoint}#{proxy.api_test_path}#{query}" #{extheaders}}
    end
  end

  def is_https?(url)
    begin
      uri = URI.parse(url)
      uri.is_a? URI::HTTPS
    rescue URI::InvalidURIError
      false
    end
  end


  def different_from_current?
    true #TODO: implement method
  end

  def currently_deploying?(proxy)
    @deploying
  end

  def deployed?(proxy)
    @ever_deployed_hosted
  end

  def apicast_configuration_driven?
    current_account.provider_can_use?(:apicast_v2)
  end

  def apicast_custom_urls?
    Rails.application.config.three_scale.apicast_custom_url
  end

  def custom_backend?
    # this should probably be its own config
    Rails.configuration.three_scale.active_docs_proxy_disabled
  end
end
