#!/usr/bin/perl

use POSIX;


if (not @ARGV || @ARGV != 2) {
    print "Usage: ./pack-info.pl [USER HOST]\n";
    print "$ARGV[0]\n";
    exit(1);
}

if (@ARGV == 2) {
  our $ssh = 1;
  $host = $ARGV[1];
  $user = $ARGV[0];
}
if (not @ARGV) {
  our $ssh = 0;
  $host=`hostname`;

}


$release =&run_com('cat /etc/redhat-release');
chomp($release);
chomp($host);
$output = &run_com('rpm -qa --qf "%{NAME}|%{VERSION}|%{RELEASE}|%{INSTALLTIME}|%{VENDOR}|%{BUILDTIME}|%{BUILDHOST}|%{SOURCERPM}|%{LICENSE}|%{PACKAGER}\n"');

print $output
@lines = split(/\n/, $output);


$greatest = -1;
$rhcount = 0;

for($i = 0; $i < @lines; $i++) {
   @cols = split(/\|/, $lines[$i]);
   if (index($cols[6], 'build.redhat.com') > -1 and 
            index($cols[6], 'fedora') == -1 and 
            index($cols[6], 'rhndev') == -1) {
      $rhcount++;
      if ($greatest = -1) {
         $greatest = $i;
      }
      elsif( $lines[$greatest][3] < $cols[3]) {
         $greatest = $i;
      }
   }

}

$result = "";
if ($greatest != -1) {
  $result = $result."$host ($release); Red Hat: Y;  Last Red Hat package installed: ";
  @cols = split(/\|/, $lines[$greatest]);
  $result = $result.$cols[0]."-".$cols[1]."-".$cols[2];
  $result = $result." installed on ";
  $time = localtime($cols[3] + 0);
  $result = $result."$time; ";
  $result = $result."Red Hat Packages: $rhcount/".scalar @lines; 
  $result = $result.";".`date +%s`."\n";
} 
else {
   $result =  "$host ($release), Red Hat: N.\n";
}   

&save_results($result, $host);


sub save_results {
   $output = $_[0];
   $host = $_[1];
   open FILE, ">>", "$host.txt" or print "ERROR, cannot write file";
   print FILE $output;
   close FILE;
   `zip $host.zip $host.txt`;
   `rm $host.txt`;
   if(!$ssm) {
      print "Please submit $host.zip\n";
   }
}

sub run_com {
   $com = $_[0];
   if ($ssh) {
      $com = "ssh ".$user."@".$host." '".$com."'";
      return `$com`;
   }
   else {
      return `$com`;
   }
}
